#################################################################################
#################### IMPORTATION ET MODIFICATION DES DONNEES ####################
#################################################################################





#Importation des librairies 
import seaborn as sns
import matplotlib.pyplot as plt
   
#sert à calculer l'âge de chaque candidat 
from datetime import datetime
   
#Pandas sert à créer, importer ou encore gérer des tableaux de données
import pandas as pd
   
#String nous servira à importer les lettres de l'alphabet
import string
    
#Cette librairie nécessite de taper la commande "pip install fuzzywuzzy" dans la console
#Elle permet de chercher des correspondances entre des mots à un certain degré de confiance
#Elle sera utilisée dans le nettoyage des données de la colonne langue
from fuzzywuzzy import fuzz

#Un layout = gestionnaire de mise en page de l'interface
#pour positionner les images: utiliser un QLabel pour afficher l'image et le positionner à l'aide d'un layout
#self = argument qui dit dans une class ou dans une def que l'action est spécifique 

from PyQt5.QtWidgets import QApplication, QMainWindow, QWidget, QGridLayout, QLabel, QPushButton, QMessageBox, QDialog, QVBoxLayout,QHBoxLayout,QInputDialog,QTextBrowser, QMessageBox
from PyQt5.QtCore import Qt
from PyQt5.QtCore import QFile
from PyQt5.QtGui import QPixmap
from PyQt5.QtWidgets import QLineEdit

#Assignement des noms des dataframes à des dataframes vides pour ne pas afficher de messages d'erreurs
df = pd.DataFrame()
df3 = pd.DataFrame()
df_eval = pd.DataFrame()


#Réassignement des noms des colonnes pour df et df3, pour faciliter l'appel des colonnes
id_candidat = "ID candidat"
date_info_collective = "Date de l'info collective " 
linguiste = "Est-ce un linguiste ?"
langue = "Si le/la candidate est linguiste, Quelle langue ? "
travail_IMA = "Le/la candidate a t-il/elle déjà travaillé à IMA ? "
travail_handi = "Avez-vous une reconnaissance Travailleur handicapé ? "
nationalite_etrangere = "Etes-vous de nationalité étrangère ? "
note_globale = "Note globale"
avis = "Avis Général Recruteur"
fin_periode_essai_entr = "Fin période d'essai Initiative entreprise"
fin_periode_essai_salarie = "Fin de préiode essai initiative salarié"
id_recruteur = "ID_Recruteur/Manager"
sexe = "Sexe"
date_nais = "Date de naissance"
formation = "Quel est son niveau de formation"
dispo = "A partir de quelle date est-il/elle disponible ?"
situation = "Quelle est sa situation par rapport à l'emploi"
nom_colonnes = list(df.columns)
for colonne in nom_colonnes :
        if "Critère MOTIVATION pour travailler à IMA / sur le poste de CHASS / Parcours professionnel (10 min)" in colonne :
            note_motivation = colonne
        elif "Critère L'ENVIE D'APPRENDRE (10 min)" in colonne :
            note_apprendre = colonne
        elif "Critère MATURITE PROFESSIONNELLE : Bon sens / écoute / stress (15 min)" in colonne :
            note_maturite_pro = colonne
        elif "Critère CAPACITE D'ADAPTATION / REMISE EN QUESTION  (10 min)" in colonne :
            note_adaptation = colonne
        elif "Critère MODE DE COMMUNICATION EN ENTREPRISE (5 min)" in colonne :
            note_communication = colonne     
  

def importerDonnees(CheminAcces1, CheminAcces2):
    
    try:
    
        #Transformation des variables locales en variables globales pour pouvoir les enregistrer
        global df
        global df2
        global note_adaptation
        global note_apprendre
        global note_communication
        global note_globale
        global note_maturite_pro
        global note_motivation

        #Importation des fichiers excel stockant les données
        df = pd.read_excel(CheminAcces1)
        df2 = pd.read_excel(CheminAcces2)
        
        nom_colonnes = list(df.columns)
        for colonne in nom_colonnes :
            if "Critère MOTIVATION pour travailler à IMA / sur le poste de CHASS / Parcours professionnel (10 min)" in colonne :
                note_motivation = colonne
            elif "Critère L'ENVIE D'APPRENDRE (10 min)" in colonne :
                note_apprendre = colonne
            elif "Critère MATURITE PROFESSIONNELLE : Bon sens / écoute / stress (15 min)" in colonne :
                note_maturite_pro = colonne
            elif "Critère CAPACITE D'ADAPTATION / REMISE EN QUESTION  (10 min)" in colonne :
                note_adaptation = colonne
            elif "Critère MODE DE COMMUNICATION EN ENTREPRISE (5 min)" in colonne :
                note_communication = colonne     
                
        #Suppression des colonnes du dataframe "df2" (fichier excel "synthèse") qui existent déjà dans le "df" (fichier excel "recrutement")
        df2 = df2.drop([date_info_collective, "Est-ce un linguiste ? Est-il /elle prête à être évalué.e ? ", "TOTAL", langue, travail_IMA, travail_handi, nationalite_etrangere, note_adaptation, note_apprendre, note_communication, note_maturite_pro, note_motivation], axis = 1)
        
        nettoyage()
        nvVariables()
        profilage_candidats()
        
        QMessageBox.information(None, "Exportation terminée", "Les données ont été importées avec succès !")
    
    except FileNotFoundError :
        QMessageBox.critical(None, "Erreur", "Le chemin d'accès spécifié est invalide")



##############################################################################
#################### STOCKAGE DES FONCTIONS ET PROCEDURES ####################
##############################################################################





#Profilage des candidats selon plusieurs critères stockés dans une liste (colonne, critère, type de filtrage)
def profilage(criteres : list):
    nom_criteres = list(df3.columns)

    for element in criteres :
      
        #Vérifie le type de donnée du critère
        if type(element[1]) == int :
            
            #Vérifie le type d'opération qu'on effectue sur le critère
            if element[2] == ">=" : 
                
                #Application du filtrage dans la colonne précisée dans le critère
                candidats_acceptes = df3[df3[element[0]] >= element[1]].iloc[:, 0]
                
                #Vérifie si chaque candidat est accepté ou refusé
                df_eval[nom_criteres[df3.columns.get_loc(element[0])]] = ['Favorable' if candidat in candidats_acceptes.values else 'Refusé' for candidat in df3.iloc[:, 0]]
    
            if element[2] == "<=" : 
                candidats_acceptes = df3[df3[element[0]] <= element[1]].iloc[:, 0]
                
                #Vérifie si chaque candidat est accepté ou refusé
                df_eval[nom_criteres[df3.columns.get_loc(element[0])]] = ['Favorable' if candidat in candidats_acceptes.values else 'Refusé' for candidat in df3.iloc[:, 0]]
    
            if element[2] == "=" : 
                candidats_acceptes = df3[df3[element[0]] == element[1]].iloc[:, 0]
                
                #Vérifie si chaque candidat est accepté ou refusé
                df_eval[nom_criteres[df3.columns.get_loc(element[0])]] = ['Favorable' if candidat in candidats_acceptes.values else 'Refusé' for candidat in df3.iloc[:, 0]]
    
    #Vérifie le type de donnée du critère
        elif type(element[1]) == str :
            
            #Vérifie le type d'opération qu'on effectue sur le critère
            if element[2] == "!=" : 
                
                #Application du filtrage dans la colonne précisée dans le critère
                candidats_refusés = df3[df3[element[0]] != element[1]].iloc[:, 0]
                
                #Vérifie si chaque candidat est accepté ou refusé
                df_eval[nom_criteres[df3.columns.get_loc(element[0])]] = ['Refusé' if candidat in candidats_refusés.values else 'Favorable' for candidat in df3.iloc[:, 0]]
            
            if element[2] == "=" : 
                candidats_refusés = df3[df3[element[0]] == element[1]].iloc[:, 0]
                
                #Vérifie si chaque candidat est accepté ou refusé
                df_eval[nom_criteres[df3.columns.get_loc(element[0])]] = ['Refusé' if candidat in candidats_refusés.values else 'Favorable' for candidat in df3.iloc[:, 0]]
    
    #Vérifie le type de donnée du critère
        elif type(element[1]) == list :
            
            #Vérifie le type d'opération qu'on effectue sur le critère
            if element[2] == "notin" :
                
                #Application du filtrage dans la colonne précisée dans le critère
                liste = element[1]
                candidats_refusés = df3[~df3[element[0]].isin(liste)].iloc[:, 0]
                
                #Vérifie si chaque candi dat est accepté ou refusé
                df_eval[nom_criteres[df3.columns.get_loc(element[0])]] = ['Refusé' if candidat in candidats_refusés.values else 'Favorable' for candidat in df3.iloc[:, 0]]
            
            if element[2] == "in" :
                liste = element[1]
                candidats_refusés = df3[df3[element[0]].isin(liste)].iloc[:, 0]
                
                #Vérifie si chaque candi dat est accepté ou refusé
                df_eval[nom_criteres[df3.columns.get_loc(element[0])]] = ['Refusé' if candidat in candidats_refusés.values else 'Favorable' for candidat in df3.iloc[:, 0]]
        
        
        
#Permet de nettoyer la colonne concernant les langues parlées
#Fait avec la librairie "fuzzywuzzy" (voir plus haut)
def extraire_langue(phrase):
    langues = [
        "anglais", "espagnol", "portugais", "français", "italien", "allemand", "néerlandais",
        "suédois", "danois", "norvégien", "finnois", "polonais", "russe", "ukrainien", "tchèque",
        "slovaque", "serbe", "croate", "hongrois", "roumain", "bulgare", "grec", "turc",
        "chinois mandarin", "hindi", "arabe", "bengali", "japonais", "punjabi", "javanais",
        "coréen", "telugu", "marathi", "tamoul", "vietnamien", "ourdou"
    ]

    #Initialise une liste vide pour stocker les correspondances trouvées
    matches = []

# Parcourt chaque mot de la phrase après avoir converti en minuscules et divisé en mots individuels
    for mot in str(phrase).lower().split():
    # Calcule les scores de similarité entre le mot et chaque langue de la liste
        meilleurs_scores = [(langue, fuzz.ratio(mot, langue)) for langue in langues]
    
    # Trie les scores par ordre décroissant pour obtenir les correspondances les plus similaires en premier
        meilleurs_scores.sort(key=lambda x: x[1], reverse=True)
    
    # Sélectionne le meilleur match, c'est-à-dire la correspondance avec le score le plus élevé
        meilleur_match = meilleurs_scores[0]
    
    # Vérifie si le score de similarité du meilleur match est supérieur ou égal à 70
        if meilleur_match[1] >= 70:
        # Ajoute le mot correspondant à la liste des correspondances
            matches.append(meilleur_match[0])
    
    # Retourner les mots trouvés séparés par des espaces
    return ' '.join(matches)


#Détermine des classes selon la durée pour que le candidat soit disponible
def classes_mois(difference):
    if difference <= 30: 
         #Moins d'un mois
        return 1
    elif difference <= 60:  
        #De 1 à 2 mois
        return 2  
    elif difference <= 90: 
        #De 2 à 3 mois
        return 3  
    elif difference <= 120: 
        #De 3 à 4 mois
        return 4  
    elif difference <= 150:  
        #De 4 à 5 mois
        return 5  
    elif difference <= 180: 
        #De 5 à 6 mois
        return 6
    elif difference <= 210: 
        #De 6 à 7 mois
        return 7  
    elif difference <= 240: 
        #De 7 à 8 mois
        return 8  
    elif difference <= 270: 
         #De 8 à 9 mois
        return 9 
    elif difference <= 300: 
        #De 9 à 10 mois
        return 10  
    elif difference <= 330:
        #De 10 à 11 mois
        return 11  
    elif difference <= 365:
        #Plus de 12 mois
        return 12  
    else:
        return None  # Gestion des valeurs non valides
    
    
    
#Calcul de l'âge de chaque candidat à partir de sa date de naissance
def calcul_age(anniv):
    
    #Calcul de l'age
    aujourdhui = datetime.today()
    age = aujourdhui.year - anniv.year
    
    #Vérifie si l'anniversaire de cette année est déjà passé
    if aujourdhui.month < anniv.month or (aujourdhui.month == anniv.month and aujourdhui.day < anniv.day):
        age -= 1
    
    return age  


#Permet la recherche de listes pour des filtrages
def recherche_liste(liste_recherchee, liste_principale):
    for element in liste_recherchee:
        if element not in liste_principale:
            return False
    return True





###############################################################
#################### NETTOYAGE DES DONNEES ####################
###############################################################




    
def nettoyage() :    
    
    global df3
    
 #Nettoyage de la colonne "Si le/la candidate est linguiste, Quelle langue ?" grâce à la fonction "extraire_langue"
    df[langue] = df[langue].apply(extraire_langue)
    
    #Remplacement des valeurs vides des colonnes par "non renseigné"
    colonnes_a_traiter = [nationalite_etrangere,travail_handi,travail_IMA,langue]
    for colonnes in colonnes_a_traiter :
        df[colonnes] = df[colonnes].fillna('non renseigné')
    
    
    # Remplacer les valeurs vides de la colonne "Si le/la candidate est linguiste, Quelle langue ?" par "non"
    df[linguiste] = df[linguiste].replace('', 'non')
    
    
    # Remplacer les valeurs manquantes par "0" dans les colonnes concernant les notes de l'entretetien
    colonnes_a_traiter = [note_motivation,note_apprendre, note_maturite_pro, note_adaptation, note_communication, note_globale]
    for colonne in colonnes_a_traiter :
        df[colonnes_a_traiter] = df[colonnes_a_traiter].fillna(0)
        # Remplacer les occurrences de "Favorable" par "5" dans les colonnes
        df[colonnes_a_traiter] = df[colonnes_a_traiter].replace('Favorable', 5)
    
    
    #On refait les calculs de la colonne "Note globale" afin de s'assurer que les calculs soient bons
    df[note_globale] = df[note_motivation] + df[note_apprendre] + df[note_maturite_pro] + df[note_adaptation] + df[note_communication]
    
    #Fusion des dataframes "df" (correspondant au fichier excel "recrutement") et "df2" (correspondant au fichier excel "synthèse") dans un dataframe nommé "df3"
    df3 = df.merge(df2, left_on='ID candidat', right_on='ID_Candidat', how='inner')
    df3 = df3.drop(["ID_Candidat"], axis = 1)
    
    #Création du fichier excel "fichier" qui contient la fusion des fichiers excel "recrutement" et "synthèse" (sans les colonnes en double)
    df3.to_csv("fichier.csv",sep=";",encoding="utf-16-be",index=False)
    
    
    
    
    
#######################################################################
#################### CREATION DE NOUVELLES DONNEES ####################
#######################################################################





def nvVariables():
        global df3
        #Conversion de la variable "Date de naissance" en un format date valide que l'on pourra exploiter
        df3[date_nais] = pd.to_datetime(df3[date_nais], format='%Y-%m-%d')
        
        #Calcul de l'âge avec la fonction "calcul_age" et création de la colonne "age" dans le dataframe "df3"
        df3['age'] = df3[date_nais].apply(calcul_age)
        
        #Définir les limites des classes d'âge
        age_bornes = [18, 28, 38, 48, 58, float('inf')]
        age_labels = ['18-28', '28-38', '38-48', '48-58', '58+']
        
        #Convertir la colonne 'age' en type numérique
        df3['age'] = pd.to_numeric(df3['age'], errors='coerce')
        
        #Remplacer les valeurs non valides ou manquantes de la colonne "age" par 0
        df3['age'] = df3['age'].fillna(0)
        
        #Convertir les valeurs de la colonne 'age' en type entier
        df3['age'] = df3['age'].astype(int)
        
        #Ajouter une colonne 'classe_age' basée sur les classes d'âge
        df3['classe_age'] = pd.cut(df3['age'], bins=age_bornes, labels=age_labels, right=False)
        
        
        
        #Calcule le temps entre la date d'entretien et la disponibilité
        df3["difference"] = df3[dispo] - df3[date_info_collective]
        
        #transtypage afin de convertir la date (nombre de jours) en nombre entier
        df3["difference"] = df3["difference"].astype('timedelta64[D]')
        
        # Applique la fonction 'classes_mois' à la colonne 'difference' et assigne le résultat à la colonne 'classes_mois'
        df3["classes_mois"] = df3["difference"].apply(classes_mois)





#################################################################
#################### PROFILAGE DES CANDIDATS ####################
#################################################################





def profilage_candidats() :
    #ce code permet de verifier que le score total de la note globale est bien >14.
    #si c'est le cas, le candidat recoit un favorable. sinon il recoit un refusé. 
    #notre but final aprés avoir effectué plusierus autres tests sur d'autres variables
    # sera de comptabiliser le nombre de favorable total sur chaque candidat pour savoir si on le prends ou non 
    global df_eval
    global resultats
    
    # Création de "df_eval" avec la colonne "id candidat", il nous servira pour noter et classer des candidats
    df_eval = pd.DataFrame()
    df_eval['Utilisateur'] = df3[id_candidat]
    
    #Liste des critères pour profiler les candidats
    #chaque critère est une liste contenant le nom de la colonne, le critère qu'on recherche, et le type d'opération qu'on souhaite faire
    criteres = [[note_globale,15,">="],["classe_age", '38-48', "!="],[formation, 'BAC+5 et plus (Master - Doctorat - DEA...)', "!="],[linguiste, 'Oui', "!="],[travail_IMA, 'Oui il/elle a déjà travaillé à IMA', "!="],[situation, ['Salarié.e CDI', 'Salarié.e CDD'], "notin"],["classes_mois",1,"="]]
    
    #On appelle la fonction "profilage" pour profiler les candidats selon une liste de critères 
    #On attribue "favorable" ou "refusé" si le candidat répond ou non au critère
    profilage(criteres)    
    
    #Comptage des acceptations et refus par candidat dans "df_eval"
    df_eval['Nombre_acceptations'] = df_eval.iloc[:, 1:].apply(lambda row: row.eq('Favorable').sum(), axis=1)
    df_eval['Nombre_refus'] = df_eval.iloc[:, 1:].apply(lambda row: row.eq('Refusé').sum(), axis=1)
    
    #Création du dataFrame "resultats"
    resultats = pd.DataFrame()
    resultats['Candidat'] = df_eval['Utilisateur']
    resultats['Note sur 7'] = df_eval['Nombre_acceptations']
    resultats['Refus'] = df_eval['Nombre_refus']
    
    #Tri du dataframe "resultats" par ordre décroissant des acceptations
    resultats = resultats.sort_values('Note sur 7', ascending=False)






#############################################################
#################### ANALYSE DES DONNEES ####################
#############################################################





def graphiques() :
    global grph1
    global grph2
    global grph3
    global grph4
    global grph5
    global grph6

    #Graphique 1
    grph1 = sns.countplot(x = df3[travail_IMA], data = df3)
    grph1.set_xticklabels(grph1.get_xticklabels(), rotation=90)
    plt.savefig("graphiques/travail_IMA.png", bbox_inches='tight')
    plt.clf()
    
    #Graphique 2
    grph2 = sns.countplot(x=df3[situation])
    grph2.set_xticklabels(grph2.get_xticklabels(), rotation=90)
    plt.savefig("graphiques/situation.png", bbox_inches='tight')
    plt.clf()
    
    #Graphique 3
    grph3 = sns.countplot(x=df3[linguiste])
    plt.savefig("graphiques/linguiste.png", bbox_inches='tight')
    plt.clf()
    
    #Graphique 4
    grph4 = sns.countplot(x = df3["classe_age"], data = df3)
    grph4.set_xticklabels(grph4.get_xticklabels(), rotation=90)
    plt.savefig("graphiques/classe_age.png", bbox_inches='tight')
    plt.clf()
    
    #Graphique 5
    grph5 = sns.countplot(x=df3[situation])
    grph5.set_xticklabels(grph5.get_xticklabels(), rotation=90)
    plt.savefig("graphiques/situation2.png", bbox_inches='tight')
    plt.clf()
    
    #Graphique 6 
    grph6 = sns.countplot(x=df3[formation])
    grph6.set_xticklabels(grph6.get_xticklabels(), rotation=90)
    plt.savefig("graphiques/formation.png", bbox_inches='tight')
    plt.clf()




###########################################################################
#################### RECHERCHE ET FILTRAGE DES DONNEES ####################
###########################################################################
        

    
 

# Import des modules nécessaires
import easygui
import sys
from PyQt5.QtWidgets import QApplication, QMainWindow, QDialog, QVBoxLayout, QHBoxLayout, QPushButton, QTableWidget, QTableWidgetItem
from PyQt5.QtCore import QThread
import pandas as pd

# Fonction pour vérifier si une liste est présente dans une autre liste
def recherche_liste(liste_recherchee, liste_principale):
    for element in liste_recherchee:
        if element not in liste_principale:
            return False
    return True

# Fonction pour afficher les données filtrées dans une fenêtre pop-up
def afficher_pop_up_dataframe(df):
    easygui.textbox(msg="id des candidats filtrés", title="DataFrame", text=df.to_string())

# Fonction de filtrage des données
def filtre(df):
    try:
        # Sélection des modalités de score
        score_selection = easygui.multchoicebox(msg="Sélectionnez les modalités de score souhaitées:",
                                                choices=df.iloc[:, 12].unique().tolist())
        
        # Sélection des modalités de tranche d'âge
        age_selection = easygui.multchoicebox(msg="Sélectionnez les modalités de tranche d'âge souhaitées:",
                                              choices=df.iloc[:, 23].unique().tolist())
        
        # Sélection des modalités de niveau d'étude
        formation_selection = easygui.multchoicebox(msg="Sélectionnez les modalités de niveau d'étude souhaitées:",
                                                    choices=df.iloc[:, 19].unique().tolist())
    
        # Conversion des sélections en listes
        score_selection = score_selection if score_selection else []
        age_selection = age_selection if age_selection else []
        formation_selection = formation_selection if formation_selection else []
        
        # Récupération des modalités uniques pour chaque attribut
        score_modalites = df.iloc[:, 12].unique().tolist()
        age_modalites = df.iloc[:, 23].unique().tolist()
        formation_modalites = df.iloc[:, 19].unique().tolist()
        
        # DataFrames pour stocker les candidats filtrés
        score_candidats = pd.DataFrame()
        age_candidats = pd.DataFrame()
        formation_candidats = pd.DataFrame()
    
        # Filtrer les candidats selon les modalités sélectionnées
        if recherche_liste(score_selection, score_modalites) == False:
            score_candidats["ID candidat"] = df.iloc[:, 0]
        else:
            score_modalites = [modalite.strip() for modalite in score_selection]
            score_candidats["ID candidat"] = df[df.iloc[:, 12].isin(score_modalites)].iloc[:, 0]
        if recherche_liste(age_selection, age_modalites) == False:
            age_candidats["ID candidat"] = df.iloc[:, 0]
        else:
            age_modalites = [modalite.strip() for modalite in age_selection]
            age_candidats["ID candidat"] = df[df.iloc[:, 23].isin(age_modalites)].iloc[:, 0]
        if recherche_liste(formation_selection, formation_modalites) == False:
            formation_candidats["ID candidat"] = df.iloc[:, 0]
        else:
            formation_modalites = [modalite.strip() for modalite in formation_selection]
            formation_candidats["ID candidat"] = df[df.iloc[:, 19].isin(formation_modalites)].iloc[:, 0]
            
        # Fusion des DataFrames pour obtenir les candidats filtrés
        df_filtre1 = pd.merge(score_candidats, age_candidats, on='ID candidat', how='inner')
        df_filtre2 = pd.merge(formation_candidats, df_filtre1, on='ID candidat', how='inner')
        afficher_pop_up_dataframe(df_filtre2)
    except:
        QMessageBox.critical(None, "Erreur", "Vous n'avez pas importé les données")
  
# Classe pour exécuter le filtrage des données dans un thread séparé
class WorkerThread(QThread):
    def run(self):
        # Charger les données depuis un fichier ou une autre source
        df = df3  # Adapter le chemin et le format de fichier selon vos besoins

        # Effectuer le filtrage des candidats
        filtre(df)





#############################################################
#################### INTERFACE GRAPHIQUE ####################
#############################################################





#Def qui Sert à fermer chaque pop-up de chaque bouton 
#sans avoir toutes les pop-up qui s'ouvent en même temps

def closeDialog(dialog):
    dialog.close()
    window.show()
      
# Création de l'application
app = QApplication(sys.argv)

# Création de la fenêtre principale
window = QMainWindow()
window.setWindowTitle("Interface d'aide à la décision - SERVICE RH IMA")

# Définition d'une taille minimale du cadre
window.setMinimumSize(1000, 500)  

# Création du widget central
windowCentralWidget = QWidget()
window.setCentralWidget(windowCentralWidget)

# Création du layout
layout = QGridLayout(windowCentralWidget)

# Ajout du layout au widget central
windowCentralWidget.setLayout(layout)

##################################LES BOUTONS#############################################

# Boutons
btnCandidat = QPushButton("MEILLEURS CANDIDATS")
btnPCArefuse = QPushButton("CANDIDATS REFUSÉS SYSTEMATIQUEMENT")
btnImportExcel = QPushButton("IMPORTATION DES FICHIERS EXCEL")
btnRechercheRapide = QPushButton("RECHERCHE RAPIDE D'UN CANDIDAT")
btnRecherchePrecise = QPushButton("RECHERCHE PRECISE D'UN CANDIDAT")
btnCandidataccid =  QPushButton("ACCÉDEZ AUX CANDIDATS ACCEPTÉS")
btnExport = QPushButton("EXPORTATION DES DONNEES VERS EXCEL")
btnEtude = QPushButton("ETUDE DES DONNEES")

# On donne des noms a chaque bouton pour pouvoir modifier le style de chaque bouton indépendamment
btnCandidat.setObjectName("btnCandidat")
btnImportExcel.setObjectName("btnImportExcel")
btnPCArefuse.setObjectName("btnPCArefuse")
btnRechercheRapide.setObjectName("btnRechercheRapide")
btnRecherchePrecise.setObjectName("btnRecherchePrecise")
btnCandidataccid.setObjectName("btnAccepteId")
btnExport.setObjectName("btnExport")
btnEtude.setObjectName("btnEtude")

# QBoxLayout vertical pour les boutons du centre
buttonLayout = QVBoxLayout()

# Ajouter les boutons au layout des boutons du centre
# QBoxLayout vertical pour les boutons du bas à gauche
bottomLeftButtonLayout = QVBoxLayout()
bottomLeftButtonLayout.addWidget(btnImportExcel)
bottomLeftButtonLayout.addWidget(btnCandidataccid)
bottomLeftButtonLayout.addWidget(btnExport)

# Définir l'alignement supérieur pour le layout des boutons du bas à gauche
bottomLeftButtonLayout.setAlignment(Qt.AlignTop)

# Ajouter le layout des boutons du bas à gauche au layout principal
layout.addLayout(bottomLeftButtonLayout, 1, 0)

# Ajouter les autres boutons au layout principal
layout.addWidget(btnCandidat, 4, 0, Qt.AlignLeft | Qt.AlignTop)
layout.addWidget(btnPCArefuse, 6, 0, Qt.AlignLeft | Qt.AlignTop)
layout.addWidget(btnRechercheRapide, 3, 3, Qt.AlignRight | Qt.AlignTop)
layout.addWidget(btnRecherchePrecise, 2, 3, Qt.AlignRight | Qt.AlignTop)
layout.addWidget(btnEtude, 4, 3, Qt.AlignRight | Qt.AlignTop)

# Redimensionnement des boutons
btnCandidat.setFixedSize(300, 50)
btnPCArefuse.setFixedSize(300, 50)
btnRechercheRapide.setFixedSize(300, 50)
btnRecherchePrecise.setFixedSize(300, 50)
btnCandidataccid.setFixedSize(300, 50)
btnEtude.setFixedSize(300,50)
btnImportExcel.setFixedSize(300,50)
btnExport.setFixedSize(300, 50)

#################################### IMAGE IMA ##########################

# Création du QLabel pour afficher l'image
image_label = QLabel()
image_label.setAlignment(Qt.AlignCenter)  # Alignement au centre du QLabel

# Charger l'image à partir du chemin relatif de l'image
image_path = "imasansbg.png"
image = QPixmap(image_path)
image_label.setPixmap(image)

# Ajouter le QLabel au layout
layout.addWidget(image_label, 0, 0,Qt.AlignTop | Qt.AlignLeft)


######################### IMAGE DECO ######################################

# Chargement de l'image
image_path = "deco.png"
image = QPixmap(image_path)

# Création d'un QLabel pour afficher l'image
image_label_deco = QLabel()
image_label_deco.setPixmap(image)
image_label_deco.setAlignment(Qt.AlignCenter)  # Alignement au centre de l'image

# Ajout du QLabel contenant l'image au layout
layout.addWidget(image_label_deco, 0, 3, Qt.AlignTop | Qt.AlignRight)


###############################IMPORTATION DES FICHIERS EXCEL###########################

#definition de la QDialog(fenetre pop-up de l'application)
class ImportExcelDialog(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("Importation des fichiers excel")
        self.setFixedSize(500, 300)

        # Ajout du layout vertical pour organiser les widgets
        layout = QVBoxLayout(self)

        # Ajouter une étiquette de titre à la pop-up
        title_label = QLabel("Veuillez entrer le chemin d'accès de vos fichiers synthèse et recrutement")
        layout.addWidget(title_label)

        #Ajout de deux zones de texte
        zoneTxt1 = QLineEdit("recrutement.xlsx")
        layout.addWidget(zoneTxt1)
        zoneTxt2 = QLineEdit("synthèse.xlsx")
        layout.addWidget(zoneTxt2)
        
        btn_importerDonnees = QPushButton("Importer", self)
        layout.addWidget(btn_importerDonnees)
        btn_importerDonnees.setFixedSize(200, 20)
        
        #Importation des données
        btn_importerDonnees.clicked.connect(lambda : importerDonnees(zoneTxt1.text(), zoneTxt2.text()))
        # Ajout d'un layout horizontal pour le bouton de fermeture
        button_layout = QHBoxLayout()
        layout.addLayout(button_layout)

        # Ajouter un bouton de fermeture
        btn_fermeture = QPushButton("Fermer", self)
        btn_fermeture.setFixedSize(200, 20)
        button_layout.addWidget(btn_fermeture)

        # Connexion du signal du bouton de fermeture pour fermer la fenêtre pop-up
        btn_fermeture.clicked.connect(self.close)
        
   

# Création de la fenêtre pop-up pour le bouton "Candidat Idéal"
def showImportExcelDialog():
    dialog = ImportExcelDialog(window)
    dialog.exec_()
    closeDialog(dialog)
    
# Connexion du bouton "Candidat Idéal" avec sa fenêtre pop-up
btnImportExcel.clicked.connect(showImportExcelDialog)





#####################ESSAI POUR AFFICHAGE CANDIDATS VOULUS###################

nombre_candidats=0

def afficher_utilisateurs():
    global nombre_candidats  # Utilisation de la variable globale

    nombre_candidats, ok_pressed = QInputDialog.getInt(None, "Demande de l'application", "Entrez le nombre de candidats que vous souhaitez afficher")
    
    try :
        if ok_pressed:
            if nombre_candidats > 0:
                nombre_candidats = nombre_candidats  # Assignation de la valeur saisie à la variable globale
                #sert à calculer l'âge de chaque candidat 
    
                print("Nombre d'utilisateurs:", nombre_candidats)
                
                synthese_candidats = []
    
                age_col_index = 22
                sexe_col_index = 17
                linguiste_col_index = 3
                note_globale_col_index = 12
                # # Afficher une phrase indiquant les X meilleurs candidats
                # print(f"Les {nombre_candidats} meilleurs candidats sont :")
    
                # Afficher les X premiers candidats du DataFrame test. avec la methode to string  seules les colonnes "Candidat", "Acceptations" et "Refus" seront affichées, on perds donc l'index du df.
                resultats_recrutement = resultats.head(nombre_candidats)
                print(resultats_recrutement.to_string(index=False))
                for candidat in resultats_recrutement['Candidat']:
                    # Obtenir l'ID du candidat
                    id_candidat = candidat
                    
                    # Obtenir les informations du candidat à partir de l'ID dans le DataFrame df3
                    informations = df3[df3['ID candidat'] == id_candidat].iloc[0]
                    note_candidat = resultats[resultats['Candidat'] == id_candidat].iloc[0]
                    
                    # Extraire les informations nécessaires en utilisant les index des colonnes
                    note_candidat = note_candidat.iloc[1]
                    age = informations.iloc[age_col_index]
                    sexe = informations.iloc[sexe_col_index]
                    linguiste = informations.iloc[linguiste_col_index]
                    note_globaleSur25 = informations.iloc[note_globale_col_index]
                    
                    # Ajouter les informations à la liste synthese_candidats
                    synthese_candidats.append([candidat, age, sexe, linguiste, note_globaleSur25, note_candidat])
                    
                    
                # Création d'un DataFrame à partir de la liste synthese_candidats
                synthese_df = pd.DataFrame(synthese_candidats, columns=['Candidat', 'Age', 'Sexe', 'Linguiste', 'Note globale', 'Note candidat (sur 7)'])
    
                # Mettre le df sous HTML pour qu'il ressorte sous forme de tableau à l'affichage final
                html_synthese = synthese_df.to_html(index=False)
                
                #AFFICHAGE FINAL
                # Créer un QDialog pour afficher les n candidats
                dialog = QDialog()
                dialog.setFixedSize(500, 300)
                dialog.setWindowTitle(f"Les {nombre_candidats} meilleurs candidats sont :")
                
                # Créer un QTextBrowser et définir le contenu HTML
                text_browser = QTextBrowser()
                text_browser.setHtml(html_synthese)
                
                # Créer un layout vertical et ajouter le QTextBrowser
                layout = QVBoxLayout()
                layout.addWidget(text_browser)
                
                # Définir le layout pour le QDialog
                dialog.setLayout(layout)
                
                # Afficher le QDialog
                dialog.exec_()   
                
                #############EXPORT DU EXCEL###############
                try:
                    btnExport.clicked.connect(lambda: synthese_df.to_excel('synthese_candidats.xlsx', index=False))
                    
                    def annonce():
                        global nombre_candidats  # Utilisation de la variable globale
        
                        QMessageBox.information(None, "Exportation terminée", "Les données ont été exportées avec succès !")
                    btnExport.clicked.connect(annonce)
                except:
                    QMessageBox.critical(None, "Erreur", "Vous n'avez pas importé les données")
                    
            else:
                QMessageBox.warning(None, "Erreur de saisie", "Le nombre d'utilisateurs doit être supérieur à zéro.")
        
    except:
        QMessageBox.critical(None, "Erreur", "Vous n'avez pas importé les données")
#connexion entre le bouton et l'inputbox 
btnCandidataccid.clicked.connect(afficher_utilisateurs)


###############################RECHERCHE DES CANDIDATS PAR ID###########################

def select_candidat(nom_candidat):
    try:
        global dfC
        dfC = df3[df3[id_candidat] == nom_candidat]     
        dfC = dfC.rename(columns = {id_candidat : "id_candidat", date_info_collective : "date_info_coll", linguiste : "linguiste", langue : "langue", travail_IMA : "travail_IMA", travail_handi : "travail_handi", nationalite_etrangere : "nationalite_etrangere", note_adaptation : "note_adapt", note_apprendre : "note_appr", note_communication : "note_com", note_globale : "note_globale", note_maturite_pro : "note_maturite", avis : "avis", fin_periode_essai_entr : "fin_periode_essai_entr", fin_periode_essai_salarie : "fin_periode_essai_salarie", note_motivation : "note_motiv"})
        dfC=dfC[["id_candidat","linguiste","langue","travail_IMA", "nationalite_etrangere","avis"]]
        # Mettre le df sous HTML pour qu'il ressorte sous forme de tableau à l'affichage final
        html_dfC = dfC.to_html(index=False)
                
        #AFFICHAGE FINAL
        # Créer un QDialog pour afficher le informations du candidat
        dialog = QDialog()
        dialog.setFixedSize(400, 111)
        dialog.setWindowTitle(f"Voici les informations du candidat n°{nom_candidat} :")
        # Créer un QTextBrowser et définir le contenu HTML
        text_browser = QTextBrowser()
        text_browser.setHtml(html_dfC)
                
        # Créer un layout vertical et ajouter le QTextBrowser
        layout = QVBoxLayout()
        layout.addWidget(text_browser)
        
        # Définir le layout pour le QDialog
        dialog.setLayout(layout)
        
        # Afficher le QDialog
        dialog.exec_()   
    except:
        QMessageBox.critical(None, "Erreur", "Vous n'avez pas importé les données")

class CandidatRechercheDialog(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("Recherche de candidat par ID")
        self.setFixedSize(500, 300)

        # Ajout du layout vertical pour organiser les widgets
        layout = QVBoxLayout(self)

        # Ajouter une étiquette de titre à la pop-up
        title_label = QLabel("Recherche par ID")
        layout.addWidget(title_label)

        #Ajout de deux zones de texte
        zoneTxt = QLineEdit("Entrez un ID de candidat")
        layout.addWidget(zoneTxt)
       
        btn_RechercheID = QPushButton("Rechercher", self)
        layout.addWidget(btn_RechercheID)
        
        #Recherche candidat
        btn_RechercheID.clicked.connect(lambda : select_candidat(int(zoneTxt.text())))
        
                                     
        # Ajout d'un layout horizontal pour le bouton de fermeture
        button_layout = QHBoxLayout()
        layout.addLayout(button_layout)

        # Ajouter un bouton de fermeture
        btn_fermeture = QPushButton("Fermer", self)
        button_layout.addWidget(btn_fermeture)

        # Connexion du signal du bouton de fermeture pour fermer la fenêtre pop-up
        btn_fermeture.clicked.connect(self.close)


def rechercheCandidat():
    dialog = CandidatRechercheDialog(window)
    dialog.exec_()
    closeDialog(dialog)

btnRecherchePrecise.clicked.connect(rechercheCandidat)


############################### CHERCHE DES CANDIDATS AVEC LE FILTRE ###########################

class MainWindow(QDialog):
    def __init__(self, window):
        super().__init__(window)
        self.setWindowTitle("Filtre de candidats")
        self.setGeometry(100, 100, 300, 200)

        # Créer un bouton
        self.button = QPushButton("Filtrer les candidats", self)
        self.button.setGeometry(50, 50, 200, 50)
        self.button.clicked.connect(self.filtrer_candidats)

    def filtrer_candidats(self):
        thread = WorkerThread(self)
        thread.start()

    def showResultDialog(self, df):
        # Créer une fenêtre pop-up pour afficher les résultats
        resultDialog = QDialog(self)
        resultDialog.setWindowTitle("Résultats du filtrage")
        resultDialog.setGeometry(200, 200, 600, 400)

        # Créer un tableau pour afficher les données
        tableWidget = QTableWidget(resultDialog)
        tableWidget.setGeometry(10, 10, 580, 380)

        # Définir le nombre de lignes et de colonnes du tableau
        num_rows, num_cols = df.shape
        tableWidget.setRowCount(num_rows)
        tableWidget.setColumnCount(num_cols)

        # Remplir le tableau avec les données
        for i in range(num_rows):
            for j in range(num_cols):
                item = QTableWidgetItem(str(df.iloc[i, j]))
                tableWidget.setItem(i, j, item)

        # Afficher la fenêtre pop-up
        resultDialog.exec_()


# Création de la fenêtre pop-up pour le bouton "Candidat Refusé Systématiquement"
def showCandidatRefDialog():
    dialog = MainWindow(window)
    dialog.exec_()
    
btnRechercheRapide.clicked.connect(showCandidatRefDialog)

####################################ETUDE DES DONNEES###########################


class Etude(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("Etude des données : graphiques")

        # Layout vertical pour organiser les widgets
        layout = QVBoxLayout(self)
        
        
        df_candidat = df3.groupby(by=["classe_age"], as_index = False).size()
        nombre = df_candidat["size"].max()
        numero_index = df_candidat[df_candidat["size"] == nombre].index
        numero_index = numero_index[0]
        classe_max = df_candidat[df_candidat["size"] == nombre]["classe_age"][numero_index]
        
        
        title_label = QLabel("Répartition des candidats selon leur classe d'âge \n Axe X : classes d'âge \n Axe Y : nombre de candidats \n La classe d'âge la plus présente parmis les candidats est celle des " + str(classe_max) + "ans, avec " + str(nombre) + " candidats")
        layout.addWidget(title_label)
        
        image_label = QLabel()
        image_label.setAlignment(Qt.AlignCenter)
        
        image_emplacement = "graphiques/classe_age.png"
        image = QPixmap(image_emplacement)
        image_label.setPixmap(image)
        # Ajouter le QLabel au layout
        layout.addWidget(image_label)
        
        # Ajouter un bouton pour faire passer les graphiques
        btn_suivant = QPushButton("Suivant", self)
        layout.addWidget(btn_suivant)

        # Connexion du signal du bouton pour passer au graphique suivant
        btn_suivant.clicked.connect(self.close)
        btn_suivant.clicked.connect(lambda : Etude2(window).exec_())
        
        # Ajouter un layout horizontal pour le bouton de fermeture
        button_layout = QHBoxLayout()
        layout.addLayout(button_layout)
        
        # Ajouter un bouton de fermeture
        btn_fermeture = QPushButton("Fermer", self)
        button_layout.addWidget(btn_fermeture)

        # Connexion du signal du bouton de fermeture pour fermer la fenêtre pop-up
        btn_fermeture.clicked.connect(self.close)
        
def showEtudeDialog():
    try:
        graphiques()
        dialog = Etude(window)
        dialog.exec_()
        closeDialog(dialog)
    except:
        QMessageBox.critical(None, "Erreur", "Vous n'avez pas importé les données")
        
# Connexion du bouton "Candidat Potentiellement Accepté" avec sa fenêtre pop-up
btnEtude.clicked.connect(showEtudeDialog)

class Etude2(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("Etude des données : graphiques")
       
        # Layout vertical pour organiser les widgets
        layout = QVBoxLayout(self)
        
        df_candidat = df3.groupby(by=[formation], as_index = False).size()
        nombre = df_candidat["size"].max()
        numero_index = df_candidat[df_candidat["size"] == nombre].index
        numero_index = numero_index[0]
        classe_max = df_candidat[df_candidat["size"] == nombre][formation][numero_index]
        
        
        title_label = QLabel("Répartition des candidats selon leur formation \n Axe X : formation suivie \n Axe Y : nombre de candidats \n La formation la plus suivie parmis les candidats est " + str(classe_max) + ", avec " + str(nombre) + " candidats")
        layout.addWidget(title_label)
        
        image_label = QLabel()
        image_label.setAlignment(Qt.AlignCenter)
        
        image_emplacement = "graphiques/formation.png"
        image = QPixmap(image_emplacement)
        image_label.setPixmap(image)
        # Ajouter le QLabel au layout
        layout.addWidget(image_label)
        
        # Ajouter un bouton pour faire passer les graphiques
        btn_suivant = QPushButton("Suivant", self)
        layout.addWidget(btn_suivant)

        # Connexion du signal du bouton pour passer au graphique suivant
        btn_suivant.clicked.connect(self.close)
        btn_suivant.clicked.connect(lambda : Etude3(window).exec_())
        
        # Ajouter un bouton pour faire revenir au graphique précedent
        btn_precedent = QPushButton("Précedent", self)
        layout.addWidget(btn_precedent)

        # Connexion du signal du bouton pour revenir au graphique précedent
        btn_precedent.clicked.connect(self.close)
        btn_precedent.clicked.connect(lambda : Etude(window).exec_())
        
        # Ajouter un layout horizontal pour le bouton de fermeture
        button_layout = QHBoxLayout()
        layout.addLayout(button_layout)
        
        # Ajouter un bouton de fermeture
        btn_fermeture = QPushButton("Fermer", self)
        button_layout.addWidget(btn_fermeture)

        # Connexion du signal du bouton de fermeture pour fermer la fenêtre pop-up
        btn_fermeture.clicked.connect(self.close)
        
class Etude3(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("Etude des données : graphiques")

        # Layout vertical pour organiser les widgets
        layout = QVBoxLayout(self)
        
        df_candidat = df3.groupby(by=[linguiste], as_index = False).size()
        nombre = df_candidat["size"].max()
        numero_index = df_candidat[df_candidat["size"] == nombre].index
        numero_index = numero_index[0]
        classe_max = df_candidat[df_candidat["size"] == nombre][linguiste][numero_index]
        
        
        title_label = QLabel("Répartition des candidats selon s'ils sont linguistes ou non \n Axe X : si le candidat est linguiste ou non \n Axe Y : nombre de candidats \n Pour la question 'êtes-vous linguist', les candidats ont le plus répondu " + str(classe_max) + ", avec " + str(nombre) + " réponses")
        layout.addWidget(title_label)
        
        image_label = QLabel()
        image_label.setAlignment(Qt.AlignCenter)
        
        image_emplacement = "graphiques/linguiste.png"
        image = QPixmap(image_emplacement)
        image_label.setPixmap(image)
        # Ajouter le QLabel au layout
        layout.addWidget(image_label)
        
        # Ajouter un bouton pour faire passer les graphiques
        btn_suivant = QPushButton("Suivant", self)
        layout.addWidget(btn_suivant)

        # Connexion du signal du bouton pour passer au graphique suivant
        btn_suivant.clicked.connect(self.close)
        btn_suivant.clicked.connect(lambda : Etude4(window).exec_())
        
        # Ajouter un bouton pour faire revenir au graphique précedent
        btn_precedent = QPushButton("Précedent", self)
        layout.addWidget(btn_precedent)

        # Connexion du signal du bouton pour revenir au graphique précedent
        btn_precedent.clicked.connect(self.close)
        btn_precedent.clicked.connect(lambda : Etude2(window).exec_())
        
        # Ajouter un layout horizontal pour le bouton de fermeture
        button_layout = QHBoxLayout()
        layout.addLayout(button_layout)
        
        # Ajouter un bouton de fermeture
        btn_fermeture = QPushButton("Fermer", self)
        button_layout.addWidget(btn_fermeture)

        # Connexion du signal du bouton de fermeture pour fermer la fenêtre pop-up
        btn_fermeture.clicked.connect(self.close)
        
class Etude4(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("Etude des données : graphiques")
        
        # Layout vertical pour organiser les widgets
        layout = QVBoxLayout(self)
        
        df_candidat = df3.groupby(by=[travail_IMA], as_index = False).size()
        nombre = df_candidat["size"].max()
        numero_index = df_candidat[df_candidat["size"] == nombre].index
        numero_index = numero_index[0]
        classe_max = df_candidat[df_candidat["size"] == nombre][travail_IMA][numero_index]
        
        
        title_label = QLabel("Répartition des candidats selon s'ils ont déjà travaillé à l'IMA ou non \n Axe X : si les candidats ont déjà travaillé à l'IMA ou non \n Axe Y : note \n La réponse ressortant le plus est " + str(classe_max) + ", pour " + str(nombre) + " candidats")
        layout.addWidget(title_label)
        
        image_label = QLabel()
        image_label.setAlignment(Qt.AlignCenter)
        
        image_emplacement = "graphiques/travail_IMA.png"
        image = QPixmap(image_emplacement)
        image_label.setPixmap(image)
        # Ajouter le QLabel au layout
        layout.addWidget(image_label)

        # Ajouter un bouton pour faire passer les graphiques
        btn_suivant = QPushButton("Suivant", self)
        layout.addWidget(btn_suivant)

        # Connexion du signal du bouton pour passer au graphique suivant
        btn_suivant.clicked.connect(self.close)
        btn_suivant.clicked.connect(lambda : Etude5(window).exec_())
        
        # Ajouter un bouton pour faire revenir au graphique précedent
        btn_precedent = QPushButton("Précedent", self)
        layout.addWidget(btn_precedent)

        # Connexion du signal du bouton pour revenir au graphique précedent
        btn_precedent.clicked.connect(self.close)
        btn_precedent.clicked.connect(lambda : Etude3(window).exec_())
        
        # Ajouter un layout horizontal pour le bouton de fermeture
        button_layout = QHBoxLayout()
        layout.addLayout(button_layout)
        
        # Ajouter un bouton de fermeture
        btn_fermeture = QPushButton("Fermer", self)
        button_layout.addWidget(btn_fermeture)

        # Connexion du signal du bouton de fermeture pour fermer la fenêtre pop-up
        btn_fermeture.clicked.connect(self.close)
        
class Etude5(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("Etude des données : graphiques")

        # Layout vertical pour organiser les widgets
        layout = QVBoxLayout(self)
        
        df_candidat = df3.groupby(by=[situation], as_index = False).size()
        nombre = df_candidat["size"].max()
        numero_index = df_candidat[df_candidat["size"] == nombre].index
        numero_index = numero_index[0]
        classe_max = df_candidat[df_candidat["size"] == nombre][situation][numero_index]
        
        
        title_label = QLabel("Répartition des candidats selon leur situation par rapport à l'emploi \n Axe X : situation d'emploi \n Axe Y : nombre de candidats \n Les candidats sont pour la plupart en " + str(classe_max) + ", pour " + str(nombre) + " candidats")
        layout.addWidget(title_label)
        
        image_label = QLabel()
        image_label.setAlignment(Qt.AlignCenter)
        
        image_emplacement = "graphiques/situation.png"
        image = QPixmap(image_emplacement)
        image_label.setPixmap(image)
        # Ajouter le QLabel au layout
        layout.addWidget(image_label)
        
        # Ajouter un bouton pour faire revenir au graphique précedent
        btn_precedent = QPushButton("Précedent", self)
        layout.addWidget(btn_precedent)

        # Connexion du signal du bouton pour revenir au graphique précedent
        btn_precedent.clicked.connect(self.close)
        btn_precedent.clicked.connect(lambda : Etude4(window).exec_())
        
        # Ajouter un layout horizontal pour le bouton de fermeture
        button_layout = QHBoxLayout()
        layout.addLayout(button_layout)
        
        # Ajouter un bouton de fermeture
        btn_fermeture = QPushButton("Fermer", self)
        button_layout.addWidget(btn_fermeture)

        # Connexion du signal du bouton de fermeture pour fermer la fenêtre pop-up
        btn_fermeture.clicked.connect(self.close)
        

############################################BOUTON MEILLEUR CANDIDAT#################################

def create_modes():
    global resultats
    try:
    # Trouver les lignes avec le score d'acceptation le plus élevé
        max_acceptation = resultats['Note sur 7'].max()
        profil_type = resultats[resultats['Note sur 7'] == max_acceptation]
    # Effectuer la jointure sur la première colonne avec df3 pour obtenir les valeurs communes
        profil_type = pd.merge(profil_type, df3, left_on=profil_type.columns[0], right_on=df3.columns[0])
        profil_type= profil_type.iloc[:, 3:29]
        profil_type=profil_type.drop(profil_type.columns[7:12], axis=1)
        profil_type=profil_type.drop(profil_type.columns[0:2], axis=1)
        profil_type=profil_type.drop(profil_type.columns[3], axis=1)
        profil_type=profil_type.drop(profil_type.columns[4:10], axis=1)
        profil_type=profil_type.drop(profil_type.columns[4], axis=1)
        profil_type=profil_type.drop(profil_type.columns[7], axis=1)
        profil_type=profil_type.drop(profil_type.columns[8], axis=1)
        profil_type=profil_type.drop(profil_type.columns[5], axis=1)
        profil_type = profil_type.rename(columns = {'Month_Class' :"Pret à travailler d'ici (nombre de mois)"})
        # Calculer les modes de chaque colonnne du DataFrame
        modes= profil_type.mode().iloc[0]
        modes=pd.DataFrame(modes)
        df_modes = pd.DataFrame(modes).transpose()
        html_modes = df_modes.to_html(index=False)
        #AFFICHAGE FINAL
        # Créer un QDialog pour afficher le informations du candidat
        dialog = QDialog()
        dialog.setFixedSize(800, 160)
        dialog.setWindowTitle(f"Voici les caracteristiques des meilleurs candidats")
        # Créer un QTextBrowser et définir le contenu HTML
        text_candidat = QTextBrowser()
        text_candidat.setHtml(html_modes)       
        # Créer un layout vertical et ajouter le QTextBrowser
        layout_proofil_ideal = QVBoxLayout()
        layout_proofil_ideal.addWidget(text_candidat) 
        # Définir le layout pour le QDialog
        dialog.setLayout(layout_proofil_ideal)
        # Afficher le QDialog
        dialog.exec_()
    except:
        QMessageBox.critical(None, "Erreur", "Vous n'avez pas importé les données")

class CandidaIdeal(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("Afficher le profil ideal")
        self.setFixedSize(500, 300)

        # Ajout du layout vertical pour organiser les widgets
        layout = QVBoxLayout(self)

        # Ajouter une étiquette de titre à la pop-up
        title_label = QLabel("Profil idéal")
        layout.addWidget(title_label)

       
        btnCandidatProfil = QPushButton("Afficher le profil ideal", self)
        layout.addWidget(btnCandidatProfil)
        
        #Recherche candidat
        btnCandidatProfil.clicked.connect(lambda : create_modes())
                       
        # Ajout d'un layout horizontal pour le bouton de fermeture
        button_layout = QHBoxLayout()
        layout.addLayout(button_layout)

        # Ajouter un bouton de fermeture
        btn_fermeture = QPushButton("Fermer", self)
        button_layout.addWidget(btn_fermeture)

        # Connexion du signal du bouton de fermeture pour fermer la fenêtre pop-up
        btn_fermeture.clicked.connect(self.close)


def rechercheProfilIdeal():
    dialog = CandidaIdeal(window)
    dialog.exec_()
    closeDialog(dialog)

btnCandidat.clicked.connect(rechercheProfilIdeal)

##########################################BOUTON CANDIDAT REFUSE####################################


def create_modes_ref():
    global resultats
    try:
    # Trouver les lignes avec le score d'acceptation le plus élevé
        min_acceptation = resultats['Note sur 7'].min()
        profil_type = resultats[resultats['Note sur 7'] == min_acceptation]
    # Effectuer la jointure sur la première colonne avec df3 pour obtenir les valeurs communes
        profil_type = pd.merge(profil_type, df3, left_on=profil_type.columns[0], right_on=df3.columns[0])
        profil_type= profil_type.iloc[:, 3:29]
        profil_type=profil_type.drop(profil_type.columns[7:12], axis=1)
        profil_type=profil_type.drop(profil_type.columns[0:2], axis=1)
        profil_type=profil_type.drop(profil_type.columns[3], axis=1)
        profil_type=profil_type.drop(profil_type.columns[4:10], axis=1)
        profil_type=profil_type.drop(profil_type.columns[4], axis=1)
        profil_type=profil_type.drop(profil_type.columns[7], axis=1)
        profil_type=profil_type.drop(profil_type.columns[8], axis=1)
        profil_type=profil_type.drop(profil_type.columns[5], axis=1)
        profil_type = profil_type.rename(columns = {'Month_Class' :"Pret à travailler d'ici (nombre de mois)"})
        # Calculer les modes de chaque colonnne du DataFrame
        modes= profil_type.mode().iloc[0]
        modes=pd.DataFrame(modes)
        df_modes = pd.DataFrame(modes).transpose()
        html_modes = df_modes.to_html(index=False)       
        #AFFICHAGE FINAL
        # Créer un QDialog pour afficher le informations du candidat
        dialog = QDialog()
        dialog.setFixedSize(800, 160)
        dialog.setWindowTitle(f"Voici les caracteristiques des meilleurs candidats")
        # Créer un QTextBrowser et définir le contenu HTML
        text_candidat = QTextBrowser()
        text_candidat.setHtml(html_modes)       
        # Créer un layout vertical et ajouter le QTextBrowser
        layout_proofil_ideal = QVBoxLayout()
        layout_proofil_ideal.addWidget(text_candidat) 
        # Définir le layout pour le QDialog
        dialog.setLayout(layout_proofil_ideal)
        # Afficher le QDialog
        dialog.exec_()  
    except:
        QMessageBox.critical(None, "Erreur", "Vous n'avez pas importé les données")


class CandidaRef(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("Afficher le profil refusable")
        self.setFixedSize(500, 300)

        # Ajout du layout vertical pour organiser les widgets
        layout = QVBoxLayout(self)

        # Ajouter une étiquette de titre à la pop-up
        title_label = QLabel("Profil refusable")
        layout.addWidget(title_label)

       
        btnCandidatProfilRef = QPushButton("Afficher le profil refusable", self)
        layout.addWidget(btnCandidatProfilRef)
        
        #Recherche candidat
        btnCandidatProfilRef.clicked.connect(lambda : create_modes_ref())
                       
        # Ajout d'un layout horizontal pour le bouton de fermeture
        button_layout = QHBoxLayout()
        layout.addLayout(button_layout)

        # Ajouter un bouton de fermeture
        btn_fermeture = QPushButton("Fermer", self)
        button_layout.addWidget(btn_fermeture)

        # Connexion du signal du bouton de fermeture pour fermer la fenêtre pop-up
        btn_fermeture.clicked.connect(self.close)


def rechercheProfilRefusé():
    dialog = CandidaRef(window)
    dialog.exec_()
    closeDialog(dialog)

btnPCArefuse.clicked.connect(rechercheProfilRefusé)

################################LIAISON CSS###########################

# Chargement du fichier CSS
file = QFile("style.css")
file.open(QFile.ReadOnly | QFile.Text)
stylesheet = file.readAll().data().decode("utf-8")
file.close()

# Application du style CSS à l'interface
app.setStyleSheet(stylesheet)


##############################BOUTON POUR FERMER L'INTERFACE (window) ###############

btnfermeture = QPushButton("FERMER")
btnfermeture.setObjectName("btnFermeture")
layout.addWidget(btnfermeture, 10, 3, Qt.AlignRight)
btnfermeture.clicked.connect(window.close)

# Affichage de la fenêtre
window.show()

# Exécution de l'application
app.exec_()
